/*------------------------------------------------------------------------------*
 * File Name: ImageControl.h													*
 * Creation: CPY 9/12/2005														*
 * Purpose: Image Control in a dialog, general support							*
 * Copyright (c) OriginLab Corp. 2005											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 2006-03-17 v8.0376 QA70-8187 GET_DATA_VALUES_DIRECT_FROM_IMAGE			*
 *------------------------------------------------------------------------------*/
#ifndef _IMAGE_CONTROL_H
#define _IMAGE_CONTROL_H

#include <ImageControlBase.h>

class MOImageControl : public ImageControlBase
{
public:
	MOImageControl(PictureControl& pictCntrl)
	{
		m_pictCntrl = pictCntrl;
		m_pictCntrl.KeepAspectRatio = true;
//		m_pMatLBmp = NULL;
		/// EJP 2006-03-17 v8.0376 QA70-8187 GET_DATA_VALUES_DIRECT_FROM_IMAGE
		///m_hTempDIB = NULL;
		/// end GET_DATA_VALUES_DIRECT_FROM_IMAGE
	}
	~MOImageControl()
	{
//		if(m_pMatLBmp)
//			delete m_pMatLBmp;
		
		checkRemoveTempDIB();
	}

	//virtual
	//---- CPY 9/5/06 IMG_DLG_REMOVE_MATRIXOBJ_DEPENDENCY
//	bool SetImage(MatrixObject& mo, bool bUpdateMatrixOnDestruct);
//	MatrixObject GetMatrixObject() {return m_matObj;}
	bool SetImage(Image& img); 
	//----
	//virtual 
	pBITMAPHANDLE GetBitmapHandlePtr()
	{
	//---- CPY 9/5/06 IMG_DLG_REMOVE_MATRIXOBJ_DEPENDENCY
//		if(m_pMatLBmp)
//			//--- CPY 11/1/05 QA70-8186 LEAD_BITMAP_GR_OBJ
//			//return &m_pMatLBmp->m_LBmp;
//			return m_pMatLBmp->GetLBmpPtr();
			//----		
//		return NULL;
		//---- CPY 9/11/06 IMG_CONTROL_SHOULD_NOT_USE_SRC_LBMP_PTR_TO_EVENT
		//return m_imgSrc.GetLBmp();
		return &m_LBmpCopy;
		//----
	//-----
	}

	//virtual
	/// EJP 2006-03-17 v8.0376 QA70-8187 GET_DATA_VALUES_DIRECT_FROM_IMAGE
	///bool CopyBitmapHandle(pBITMAPHANDLE pLBmp);
	pBITMAPHANDLE CopyBitmapHandle();
	/// end GET_DATA_VALUES_DIRECT_FROM_IMAGE

	//virtual
	void Update(pBITMAPHANDLE pLBmp = NULL);
	//virtual 
	int GetImageWidth();
	//virtual 
	int GetImageHeight();

private:
	void checkRemoveTempDIB()
	{
		/// EJP 2006-03-17 v8.0376 QA70-8187 GET_DATA_VALUES_DIRECT_FROM_IMAGE
		/*
		if(m_hTempDIB)
		{
			BITMAPHANDLE lbmpTemp;
			L_CHANGE_FROM_DIB(&lbmpTemp, m_hTempDIB);
			m_hTempDIB = NULL;
			L_FreeBitmap(&lbmpTemp);
		}
		*/
		L_FreeBitmap(&m_LBmpCopy);
		/// end GET_DATA_VALUES_DIRECT_FROM_IMAGE
	}
	//---- CPY 9/5/06 IMG_DLG_REMOVE_MATRIXOBJ_DEPENDENCY
	pBITMAPHANDLE getSrcBitmapHandlePtr()
	{
		return m_imgSrc.GetLBmp();
	}
	//----
	
	//---- CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
public:	
 	virtual HWND GetParent();
	//----
private:
	PictureControl			m_pictCntrl;
	//---- CPY 9/5/06 IMG_DLG_REMOVE_MATRIXOBJ_DEPENDENCY
	//MatrixObject			m_matObj;
	//MatrixObjLeadBitmap*	m_pMatLBmp;
	BITMAPHANDLE			m_LBmpCopy;
	Image					m_imgSrc;
	//----
	/// EJP 2006-03-17 v8.0376 QA70-8187 GET_DATA_VALUES_DIRECT_FROM_IMAGE
	///HDIB 					m_hTempDIB;
	/// end GET_DATA_VALUES_DIRECT_FROM_IMAGE
};



#endif //_IMAGE_CONTROL_H





